import yaml
import json
import os
from typing import Dict, Any
from dataclasses import dataclass

@dataclass
class ModelConfig:
    """模型相关配置"""
    model_name: str
    batch_size: int
    learning_rate: float
    # 添加其他模型参数...

@dataclass
class DataConfig:
    """数据相关配置"""
    data_path: str
    train_ratio: float
    val_ratio: float
    # 添加其他数据参数...

@dataclass
class Config:
    """总配置类"""
    model: ModelConfig
    data: DataConfig
    # 可以添加其他配置类...

class ConfigLoader:
    """配置加载器"""
    
    @staticmethod
    def load_config(config_path: str) -> Dict[str, Any]:
        """
        加载配置文件/加载json文件
        Args:
            config_path: 配置文件路径
        Returns:
            配置字典
        """
        if not os.path.exists(config_path):
            raise FileNotFoundError(f"Config file not found: {config_path}")
            
        file_ext = os.path.splitext(config_path)[1].lower()
        
        try:
            if file_ext == '.yaml' or file_ext == '.yml':
                with open(config_path, 'r', encoding='utf-8') as f:
                    config = yaml.safe_load(f)
            elif file_ext == '.json':
                with open(config_path, 'r', encoding='utf-8') as f:
                    config = json.load(f)
            else:
                raise ValueError(f"Unsupported config file format: {file_ext}")
            return config
        except Exception as e:
            raise Exception(f"Error loading config file: {str(e)}")
    


