#!/bin/bash
#$ -cwd
#$ -j y
#$ -pe smp 8 # Request 8 core
#$ -l h_rt=10:0:0  # Request 1 hour runtime
#$ -l h_vmem=20G -l gpuhighmem   # Request 1GB RAM
#$ -l gpu=1 # request 1 GPU
##$ -l node_type=rdg
##$ -l rocky
module load miniforge/24.7.1
module load gcc/12.2.0
module load cmake/3.27.9-gcc-12.2.0 
module load cuda/12.2.2-gcc-12.2.0
module load openssl/3.3.0-gcc-12.2.0

mamba activate r1_video_v4
huggingface-cli login --token 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
export OPENAI_API_KEY="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"
export DECORD_EOF_RETRY_MAX=20480 
export HF_HOME="/data/home/acw652/.cache/huggingface"
export NCCL_DEBUG=INFO  # 启用详细的NCCL调试信息
export CUDA_LAUNCH_BLOCKING=1
set -x

python em_loop.py \
  --num_iters 1 \
  --base_model meta-llama/Llama-2-7b-hf \
  --adapter_path /data/DERI-Gong/jh015/grace_codes/data/sciq_brief_prob_noinit_sft_100/adapter_config.json \
  --head_init  /data/DERI-Gong/jh015/grace_codes/data/sciq_brief_prob_noinit_sft_100/confidence_head.pt \
  --target_pkl /data/DERI-Gong/jh015/grace_codes/data/triviaqa_brief/llama2-7b/hd_data_em.pkl \
  --dataset    /data/DERI-Gong/jh015/grace_codes/data/triviaqa_brief \
  --model_subdir llama2-7b \
  --exp_root   /data/DERI-Gong/jh015/grace_codes/exp/prob_noinit_binmean_em \
  --exp_name   prob_noinit_binmean \
  \
  --temp 0.7 --bias 0.6 \
  --shape_mode rank_push --rank_alpha 3.5 --mix_lambda 0.9 \
  --correctness_field correctness \
  \
  --num_train_epochs 3 --save_strategy no --logging_steps 1 --weight 1 --report_to wandb \
  --distance prob_init --loss_type distance_sft --add_soft_prompts false --debug_mode false

python analyze.py --path /data/DERI-Gong/jh015/grace_codes/data/triviaqa_brief_prob_noinit_binmean_sft_100.csv --num_bins 10