from __future__ import annotations

import os
from typing import Any, List, Optional

import torch
from transformers import PreTrainedModel

from peft.peft_model import PeftModel, PeftConfig, PeftModelForCausalLM


class MyPeftModel(PeftModel):

    def __init__(self, model: PreTrainedModel, peft_config: PeftConfig, 
                 adapter_name: str = "default", add_tokens=False):
        super().__init__(model, peft_config, adapter_name)
        self.add_tokens = add_tokens

    # def save_pretrained(
    #     self,
    #     save_directory: str,
    #     safe_serialization: bool = False,
    #     selected_adapters: Optional[List[str]] = None,
    #     **kwargs: Any,
    # ):
    #     super().save_pretrained(save_directory, safe_serialization, 
    #                             selected_adapters, **kwargs)

    #     if self.add_tokens:
    #         torch.save(self.base_model.model.get_input_embeddings().new_embedding, 
    #                     os.path.join(save_directory, "input_embeddings.pt"))
    #         torch.save(self.base_model.model.get_output_embeddings().new_linear, 
    #                     os.path.join(save_directory, "output_embeddings.pt"))
    def save_pretrained(
        self,
        save_directory: str,
        safe_serialization: bool = False,
        selected_adapters: Optional[List[str]] = None,
        **kwargs: Any,
    ):
        super().save_pretrained(save_directory, safe_serialization,
                                selected_adapters, **kwargs)

        if self.add_tokens:
            inp_emb = self.base_model.model.get_input_embeddings()
            out_emb = self.base_model.model.get_output_embeddings()
            if hasattr(inp_emb, "new_embedding"):
                torch.save(inp_emb.new_embedding,
                        os.path.join(save_directory, "input_embeddings.pt"))
            if hasattr(out_emb, "new_linear"):
                torch.save(out_emb.new_linear,
                        os.path.join(save_directory, "output_embeddings.pt"))


class MyPeftModelForCausalLM(MyPeftModel, PeftModelForCausalLM):

    def __init__(self, model, peft_config: PeftConfig, adapter_name="default", add_tokens=False):
        super().__init__(model, peft_config, adapter_name)
        self.add_tokens = add_tokens