import pickle
import pandas as pd
import sys
import os

def pkl_to_csv(pkl_path, csv_path=None):
    # 读取 pkl
    with open(pkl_path, "rb") as f:
        data = pickle.load(f)

    # 自动生成输出路径
    if csv_path is None:
        csv_path = os.path.splitext(pkl_path)[0] + ".csv"

    # 如果是 DataFrame，直接存
    if isinstance(data, pd.DataFrame):
        df = data
    elif isinstance(data, list):
        # 如果是 list[dict]，转成 DataFrame
        if all(isinstance(item, dict) for item in data):
            df = pd.DataFrame(data)
        else:
            raise ValueError("List 不是由 dict 组成，不能直接转 DataFrame")
    elif isinstance(data, dict):
        df = pd.DataFrame([data])
    else:
        raise ValueError(f"不支持的 pkl 数据类型: {type(data)}")

    df.to_csv(csv_path, index=False, encoding="utf-8-sig")
    print(f"已保存 CSV 到 {csv_path}")

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("用法: python pkl_to_csv.py your_file.pkl [output.csv]")
        sys.exit(1)
    pkl_file = sys.argv[1]
    csv_file = sys.argv[2] if len(sys.argv) > 2 else None
    pkl_to_csv(pkl_file, csv_file)
