#!/bin/bash
#$ -cwd
#$ -j y
#$ -pe smp 8 # Request 8 core
#$ -l h_rt=1:0:0  # Request 1 hour runtime
#$ -l h_vmem=12G -l gpuhighmem   # Request 1GB RAM
#$ -l gpu=1 # request 1 GPU
##$ -l node_type=rdg
##$ -l rocky
module load miniforge/24.7.1
module load gcc/12.2.0
module load cmake/3.27.9-gcc-12.2.0 
module load cuda/12.2.2-gcc-12.2.0
module load openssl/3.3.0-gcc-12.2.0

mamba activate r1_video_v4
huggingface-cli login --token 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
export OPENAI_API_KEY="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"
export DECORD_EOF_RETRY_MAX=20480 
export HF_HOME="/data/home/acw652/.cache/huggingface"
export NCCL_DEBUG=INFO  # 启用详细的NCCL调试信息
export CUDA_LAUNCH_BLOCKING=1
set -x

# echo "Starting Python script..."
# python type_inference_hd_iter.py \
#  --epoch 1 \
#  --dataset 'sciq_brief' \
#  --dataset_path '/data/DERI-Gong/jh015/grace_codes/data/'
# echo "Python script finished."

python train.py \
    --distance 'prob_init' \
    --loss_type 'distance_sft' \
    --add_soft_prompts false \
    --debug_mode false \
    --num_train_epochs 3 \
    --save_strategy 'no' \
    --logging_steps 1 \
    --weight 1 \
    --report_to 'wandb' \
    --dataset '/data/DERI-Gong/jh015/grace_codes/data/sciq_brief' \
    --processed_data 'hd_data_em_balanced.pkl' \
    --exp_name 'prob_noinit' \


python analyze.py 