#!/bin/bash
#$ -cwd
#$ -j y
#$ -pe smp 8 # Request 8 core
#$ -l h_rt=1:0:0  # Request 1 hour runtime
#$ -l h_vmem=20G -l gpuhighmem   # Request 1GB RAM
#$ -l gpu=1 # request 1 GPU
##$ -l node_type=rdg
##$ -l rocky
module load miniforge/24.7.1
module load gcc/12.2.0
module load cmake/3.27.9-gcc-12.2.0 
module load cuda/12.2.2-gcc-12.2.0
module load openssl/3.3.0-gcc-12.2.0

mamba activate r1_video_v4
huggingface-cli login --token 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
export OPENAI_API_KEY="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"
export DECORD_EOF_RETRY_MAX=20480 
export HF_HOME="/data/home/acw652/.cache/huggingface"
export NCCL_DEBUG=INFO  # 启用详细的NCCL调试信息
export CUDA_LAUNCH_BLOCKING=1
set -x

python train_calib_em.py \
  --base_model microsoft/Phi-3-mini-4k-instruct \
  --adapter_dir /data/DERI-Gong/jh015/grace_codes/data/triviaqa_brief_prob_noinit_phi_sft_100/adapter_config.json \
  --head_path /data/DERI-Gong/jh015/grace_codes/data/triviaqa_brief_prob_noinit_phi_sft_100/confidence_head.pt \
  --target_pkl /data/DERI-Gong/jh015/grace_codes/data/sciq_brief/phi3-mini-4k/hd_data_em.pkl  \
  --out_pkl /data/DERI-Gong/jh015/grace_codes/data/sciq_brief/phi3-mini-4k/processed_binmean.pkl \
  --prefix "Q: {question}\nA:" --suffix "" \
  --layer_index -1 \
  --temp 0.7 \
  --bias 0.6 \
  --shape_mode rank_push \
  --rank_alpha 3.5 \
  --mix_lambda 0.9 \
  --correctness_field correctness

python pkl_to_csv.py /data/DERI-Gong/jh015/grace_codes/data/sciq_brief/phi3-mini-4k/processed_binmean.pkl 

python train.py \
  --distance 'prob_init' \
  --loss_type 'distance_sft' \
  --add_soft_prompts false \
  --debug_mode false \
  --num_train_epochs 3 \
  --save_strategy 'no' \
  --logging_steps 1 \
  --weight 1 \
  --report_to 'wandb' \
  --dataset '/data/DERI-Gong/jh015/grace_codes/data/sciq_brief' \
  --processed_data 'processed_binmean.pkl' \
  --exp_name 'prob_noinit_binmean_phi'

python analyze.py --path /data/DERI-Gong/jh015/grace_codes/data/sciq_brief_prob_noinit_binmean_phi_sft_100.csv --num_bins 10