
## Preliminaries

The code is tested under Ubuntu Linux 20.04 and Python 3.8 environment, and requires some packages to be installed as given in requirements.txt.


## Installation

Create a virtual environment and install requirements.txt using pip or pip3 depending on python version:

```bash
pip install -r requirements.txt
```

## Usage
The code is tested on 8 datasets from the following list as given in the paper. Results are generated by running our algorithm 10 times using the no_runs command line argument.

```python
['mnist35','fmnist24','segment','wine','wind','puma8NH','cpu_small','twomoons']
```

To replicate the results on a single data-set e.g., puma8NH use the following:

```python
python eval_neurips24.py --data-sets puma8NH wine  --no_runs 10

```
It is possible to replicate the results on multiple data-sets (however it may be time consuming), e.g., two replicate results on twomoons and wine data-sets, use the following:

```python
python eval_neurips24.py --data-sets twomoons wine  --no_runs 10

```

Note that, m is d times expansion factor. Currently, we are using two separate lists for expansion factors as follows

```python
exp_factor_list = [50,100,500, 1000,1500,2000,2500,3000] # for mnist35, fmnist24, wine, wind, cpu_small, segment
exp_factor_list = [10,20,30,40,50,60,80,90,100] #for twomoons, puma8NH
```

If you want to use a different expansion factor list, you can change it on line 650 of eval_neurips24.py
