import argparse

def get_args():
    parser = argparse.ArgumentParser(description='Non-parametric classification via expand-and-sparsify representation')
    #parser.add_argument('--dataset', default="imagenet", type=str, help="['imagenet','cifar10','cifar100']")
    #parser.add_argument('--datasets', default=['mnist', 'SUN', 'Places', 'dtd'],type=list_of_strings,help="['mnist', 'LSUN', 'LSUN_resize', 'iSUN', 'dtd', 'Places']")
    parser.add_argument('--datasets', '--names-list', nargs='+', default=['mnist35','fmnist24','segment','wine','wind','puma8NH','cpu_small','twomoons'])
    parser.add_argument('--batch_size', default=2048, type=int, help='mini-batch size')
    parser.add_argument('--nw',default=12, type=int, help='number of workers')
    parser.add_argument('--topk_type',default=0, type=int, help='topk_type 0 for kWTA 1 for in expectation')
    parser.add_argument('--data_path', type=str, default='./', help='path to custom dataset')
    #parser.add_argument('--exf', type=int,default=500,help='features times exf is expanded number of features')
    parser.add_argument('--seed', type=int,default=75,help='seed fore pseudorandom number generator')
    #parser.add_argument('--topk_f', type=float,default=0.001,help='fraction of expandad number of largest features that are set to be non-zero')
    parser.add_argument('--no_runs',type=int,default=1,help='no. of trials to get average metric values')
    args = parser.parse_args()
    return args
