# Non-stationary Equivariant Graph Neural Networks for Physical Dynamics Simulation




![Overview](ns-egnn.png "Overview")


## Initialize Environment
It is suggested to use `conda` to manage the python environment, and you can install the required packages from the provided `environment.yml` directly.
```python
conda env create --file environment.yml
```


## Data Preparation

We follow the dataset preparation pipeline from [GLAD-RUC/ESTAG](https://github.com/GLAD-RUC/ESTAG):

**1. MD17**

All MD17 preprocessing scripts and train/validation/test splits are provided in the `data/MD17/` directory of the ESTAG repo.

**2. Motion Capture**

The raw data were obtained via [CMU Motion Capture Database](http://mocap.cs.cmu.edu/search.php?subjectnumber=35). The preprocessed dataset as well as the splits are provided in  `motion` folder.

**3. Protein MD**

Use the preprocessing script in this repo:

```bash
python mdanalysis/preprocess.py
```

## Training and Evaluation

**1. MD17**

```bash
python main_md.py --exp_name='exp_1' --model='nsegnn' --epochs 500 --mol='aspirin' --n_layers=4 --fft=True --eat=False --with_mask --final False --seed 0 --gpu 1
```

**2. Motion Capture**

```bash
python main_motion.py --exp_name='exp_2' --model='nsegnn' --n_layers=4 --fft=True --eat=False --with_mask --case 'walk' --time_gap 10
```

**3. Protein MD**

```bash
python main_mdanalysis.py --exp_name='exp_3' --model='nsegnn' --n_layers=4 --fft=True --eat=False --with_mask
```





## Visualization

1. We provide a simple script to visualize the motion-capture dataset under different scenarios (e.g., walk vs. run) and at various time intervals:

```bash
python visualization/plot_motion.py
```

2. Based on the predicted coordinates, launch the file `visualization/vis_md.ipynb` to display the molecule.





