import numpy as np
import sys
from datetime import datetime

sys.path.append("./")

from acfssa import SinusoidMixtureGenerator

numFundamental = 5
numSeries = 25
numTrain = 10000
optimalMatrixSize = int(np.sqrt(numSeries * numTrain))

periodLower = 10
periodUpper = 100
noiseStd = 1.0


def main():
    np.random.seed(0)
    generator = SinusoidMixtureGenerator(
        numFundamental,
        numSeries,
        periodLower,
        periodUpper,
        noiseStd,
        autoregressive=True,
        maxSlope=5.0 / numTrain,
    )
    dataset = generator.sample(2 * numTrain)
    noisy = dataset.noisyObservations
    dateString = datetime.now().strftime("%Y%m%d")
    np.save(f"datasets/samossa/synthetic_{dateString}.npy", noisy)


if __name__ == "__main__":
    main()
