## 📝 Description

- Provide a clear summary of the changes and the issue that has been addressed.
- 🛠️ Fixes # (issue number)

## ✨ Changes

Select what type of change your PR is:

- [ ] 🐞 Bug fix (non-breaking change which fixes an issue)
- [ ] 🔨 Refactor (non-breaking change which refactors the code base)
- [ ] 🚀 New feature (non-breaking change which adds functionality)
- [ ] 💥 Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] 📚 Documentation update
- [ ] 🔒 Security update

## ✅ Checklist

Before you submit your pull request, please make sure you have completed the following steps:

- [ ] 📋 I have summarized my changes in the [CHANGELOG](https://github.com/openvinotoolkit/anomalib/blob/main/CHANGELOG.md) and followed the guidelines for my type of change (skip for minor changes, documentation updates, and test enhancements).
- [ ] 📚 I have made the necessary updates to the documentation (if applicable).
- [ ] 🧪 I have written tests that support my changes and prove that my fix is effective or my feature works (if applicable).

For more information about code review checklists, see the [Code Review Checklist](https://github.com/openvinotoolkit/anomalib/blob/main/docs/source/markdown/guides/developer/code_review_checklist.md).
