# Data Tutorials

This section contains tutorials on how to fully utilize the data components of anomalib.

::::{grid} 2 2 2 3
:gutter: 2
:padding: 1

:::{grid-item-card} {octicon}`package` Dataclasses
:link: ./dataclasses
:link-type: doc

Learn how to use Anomalib's dataclasses for different modalities and batch processing.
:::

:::{grid-item-card} {octicon}`package` Datasets
:link: ./datasets
:link-type: doc

Learn how to use Anomalib's Datasets for different modalities and batch processing.
:::

:::{grid-item-card} {octicon}`package` Datamodules
:link: ./datamodules
:link-type: doc

Learn how to use Anomalib's Datamodules for different modalities and batch processing.
:::

:::{grid-item-card} {octicon}`database` Custom Data

<!-- :link: ./custom_data
:link-type: doc -->

Learn more about how to use `Folder` dataset to train anomalib models on your custom data.
:::

:::{grid-item-card} {octicon}`versions` Data Transforms
:link: ./transforms
:link-type: doc

Learn how to apply custom data transforms and random augmentations to the input images.
:::

:::{grid-item-card} {octicon}`table` Input tiling
:link: ./input_tiling
:link-type: doc

Learn more about how to use the tiler for input tiling.
:::

::::

```{toctree}
:caption: Data
:hidden:

./dataclasses
./datasets
./datamodules
./transforms
./input_tiling
```
