# Callbacks

```{grid} 2
:gutter: 2

:::{card} {octicon}`download` Model Checkpoint
:link: checkpoint
:link-type: ref

Save and manage model checkpoints during training.
:::

:::{card} {octicon}`graph` Graph Logger
:link: graph-logger
:link-type: ref

Log model computation graphs for visualization.
:::

:::{card} {octicon}`package` Load Model
:link: load-model
:link-type: ref

Load pre-trained models and weights.
:::

:::{card} {octicon}`table` Tile Configuration
:link: tile-configuration
:link-type: ref

Configure and manage image tiling settings.
:::

:::{card} {octicon}`clock` Timer
:link: timer
:link-type: ref

Track and measure execution times during training.
:::
```

(checkpoint)=

## {octicon}`download` Model Checkpoint

```{eval-rst}
.. automodule:: anomalib.callbacks.checkpoint
   :members:
   :show-inheritance:
```

(graph-logger)=

## {octicon}`graph` Graph Logger

```{eval-rst}
.. automodule:: anomalib.callbacks.graph
   :members:
   :show-inheritance:
```

(load-model)=

## {octicon}`package` Load Model

```{eval-rst}
.. automodule:: anomalib.callbacks.model_loader
   :members:
   :show-inheritance:
```

(tile-configuration)=

## {octicon}`table` Tile Configuration

```{eval-rst}
.. automodule:: anomalib.callbacks.tile_configuration
   :members:
   :show-inheritance:
```

(timer)=

## {octicon}`clock` Timer

```{eval-rst}
.. automodule:: anomalib.callbacks.timer
   :members:
   :show-inheritance:
```
