# Numpy Dataclasses

The numpy dataclasses module provides numpy-based implementations of the generic dataclasses used in Anomalib. These classes are designed to work with numpy arrays for efficient data handling and processing in anomaly detection tasks.

```{eval-rst}
.. currentmodule:: anomalib.data.dataclasses.numpy
```

## Overview

The module includes several categories of dataclasses:

- **Base Classes**: Generic numpy-based data structures
- **Image Classes**: Specialized for image data processing
- **Video Classes**: Designed for video data handling
- **Depth Classes**: Specific to depth-based anomaly detection

## Base Classes

### NumpyItem

```{eval-rst}
.. autoclass:: NumpyItem
   :members:
   :show-inheritance:
```

### NumpyBatch

```{eval-rst}
.. autoclass:: NumpyBatch
   :members:
   :show-inheritance:
```

## Image Classes

### NumpyImageItem

```{eval-rst}
.. autoclass:: NumpyImageItem
   :members:
   :show-inheritance:
```

### NumpyImageBatch

```{eval-rst}
.. autoclass:: NumpyImageBatch
   :members:
   :show-inheritance:
```

## Video Classes

### NumpyVideoItem

```{eval-rst}
.. autoclass:: NumpyVideoItem
   :members:
   :show-inheritance:
```

### NumpyVideoBatch

```{eval-rst}
.. autoclass:: NumpyVideoBatch
   :members:
   :show-inheritance:
```

## Depth Classes

### NumpyDepthItem

```{eval-rst}
.. autoclass:: NumpyDepthItem
   :members:
   :show-inheritance:
```

### NumpyDepthBatch

```{eval-rst}
.. autoclass:: NumpyDepthBatch
   :members:
   :show-inheritance:
```

## See Also

- {doc}`../index`
- {doc}`../torch`
