# Image Datamodules

Image datamodules in Anomalib are designed to handle image-based anomaly detection datasets. They provide a standardized interface for loading and processing image data for both training and inference.

## Available Datamodules

```{grid} 3
:gutter: 2

:::{grid-item-card} BTech
:link: anomalib.data.datamodules.image.BTech
:link-type: doc

Surface defect detection in steel manufacturing.
:::

:::{grid-item-card} Datumaro
:link: anomalib.data.datamodules.image.Datumaro
:link-type: doc

Dataset format compatible with Intel Geti™.
:::

:::{grid-item-card} Folder
:link: anomalib.data.datamodules.image.Folder
:link-type: doc

Custom folder-based dataset organization.
:::

:::{grid-item-card} Kolektor
:link: anomalib.data.datamodules.image.Kolektor
:link-type: doc

Surface defect detection in electrical commutators.
:::

:::{grid-item-card} MVTec
:link: anomalib.data.datamodules.image.MVTec
:link-type: doc

Industrial anomaly detection benchmark.
:::

:::{grid-item-card} Visa
:link: anomalib.data.datamodules.image.Visa
:link-type: doc

Visual inspection of surface anomalies.
:::
```

## API Reference

```{eval-rst}
.. automodule:: anomalib.data
   :members: BTech, Datumaro, Folder, Kolektor, MVTec, Visa
   :undoc-members:
   :show-inheritance:
```
