## Anomalib notebooks

This is a great place in our repo where you can try some capabilities and functions you can achive with Anomalib. First follow the installation guide and then explore the notebooks that it offer to you.

[![-----------------------------------------------------](https://user-images.githubusercontent.com/10940214/155750931-fc094349-b6ec-4e1f-9f9a-113e67941119.jpg)]()

<div id='-installation-guide'/>

## ⚙️ Installation Guide

To install Python, Git and other required tools, [OpenVINO Notebooks](https://github.com/openvinotoolkit/openvino_notebooks) repository provides a good documentation. For more details please refer to the [Installation Guide](https://github.com/openvinotoolkit/openvino_notebooks/wiki/#installation).

| [Windows](https://github.com/openvinotoolkit/openvino_notebooks/wiki/Windows) | [Ubuntu](https://github.com/openvinotoolkit/openvino_notebooks/wiki/Ubuntu) | [macOS](https://github.com/openvinotoolkit/openvino_notebooks/wiki/macOS) | [Red Hat](https://github.com/openvinotoolkit/openvino_notebooks/wiki/Red-Hat-and-CentOS) | [CentOS](https://github.com/openvinotoolkit/openvino_notebooks/wiki/Red-Hat-and-CentOS) | [Azure ML](https://github.com/openvinotoolkit/openvino_notebooks/wiki/AzureML) | [Docker](https://github.com/openvinotoolkit/openvino_notebooks/wiki/Docker) | [Amazon SageMaker](https://github.com/openvinotoolkit/openvino_notebooks/wiki/SageMaker) |
| ----------------------------------------------------------------------------- | --------------------------------------------------------------------------- | ------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------ | --------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |

[![-----------------------------------------------------](https://user-images.githubusercontent.com/10940214/155750931-fc094349-b6ec-4e1f-9f9a-113e67941119.jpg)]()

<div id='-getting-started'/>

# Useful Jupyter Notebooks to get started with Anomalib

## 0. Training and Inference

| Notebook        | GitHub                                                               | Colab                                                                                                                                                                                                                      |
| --------------- | -------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Getting Started | [001_getting_started](000_getting_started/001_getting_started.ipynb) | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/000_getting_started/001_getting_started.ipynb) |

## 1. Data Modules

| Notebook | GitHub                                         | Colab                                                                                                                                                                                                         |
| -------- | ---------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| BTech    | [101_btech](100_datamodules/101_btech.ipynb)   | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/100_datamodules/101_btech.ipynb)  |
| MVTec    | [102_mvtec](100_datamodules/102_mvtec.ipynb)   | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/100_datamodules/102_mvtec.ipynb)  |
| Folder   | [103_folder](100_datamodules/103_folder.ipynb) | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/100_datamodules/103_folder.ipynb) |

## 2. Models

| Notebook | GitHub                                        | Colab                                                                                                                                                                                                      |
| -------- | --------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Model    | [201_fastflow](200_models/201_fastflow.ipynb) | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/200_models/201_fastflow.ipynb) |

## 3. OpenVINO Optimization

| Notebook     | GitHub                                  | Colab |
| ------------ | --------------------------------------- | ----- |
| Quantization | [401_NNCF](400_openvino/401_nncf.ipynb) |       |

## 4. Use cases

| Notebook               | GitHub                                                                                             | Colab |
| ---------------------- | -------------------------------------------------------------------------------------------------- | ----- |
| Dobot Dataset Creation | [501a_training](500_use_cases/501_dobot/501a_training_a_model_with_cubes_from_a_robotic_arm.ipynb) |       |
| Training               | [501b_training](500_use_cases/501_dobot/501b_inference_with_a_robotic_arm.ipynb)                   |       |

## 7. Metrics

| Notebook                                        | GitHub                                                                 | Colab                                                                                                                                                                                                                   |
| ----------------------------------------------- | ---------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| AUPIMO basics                                   | [701a_aupimo](700_metrics/701a_aupimo.ipynb)                           | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/700_metrics/701a_aupimo.ipynb)              |
| AUPIMO representative samples and visualization | [701b_aupimo_advanced_i](700_metrics/701b_aupimo_advanced_i.ipynb)     | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/700_metrics/701b_aupimo_advanced_i.ipynb)   |
| PIMO curve and integration bounds               | [701c_aupimo_advanced_ii](700_metrics/701c_aupimo_advanced_ii.ipynb)   | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/700_metrics/701c_aupimo_advanced_ii.ipynb)  |
| (AU)PIMO of a random model                      | [701d_aupimo_advanced_iii](700_metrics/701d_aupimo_advanced_iii.ipynb) | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/700_metrics/701d_aupimo_advanced_iii.ipynb) |
| AUPIMO load/save, statistical comparison        | [701e_aupimo_advanced_iv](700_metrics/701e_aupimo_advanced_iv.ipynb)   | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/openvinotoolkit/anomalib/blob/main/examples/notebooks/700_metrics/701e_aupimo_advanced_iv.ipynb)  |
