"""DRAEM (Data-efficient Anomaly Detection and Localization) model.

The DRAEM model uses a dual-branch architecture with a reconstruction branch and
a segmentation branch to detect and localize anomalies. It is trained using
synthetic anomalies generated by augmenting normal images.

Example:
    >>> from anomalib.models.image import Draem
    >>> model = Draem()

The model can be used with any of the supported datasets and task modes in
anomalib.

Notes:
    The model implementation is available in the ``lightning_model`` module.

See Also:
    :class:`anomalib.models.image.draem.lightning_model.Draem`:
        Lightning implementation of the DRAEM model.
"""

# Copyright (C) 2022-2025 Intel Corporation
# SPDX-License-Identifier: Apache-2.0

from .lightning_model import Draem

__all__ = ["Draem"]
