# FRE: A Fast Method For Anomaly Detection And Segmentation

This is the implementation of [FRE](https://papers.bmvc2023.org/0614.pdf) paper.

Model Type: Segmentation

## Description

Fast anomaly classification algorithm that consists of a deep feature extraction stage followed by anomaly classification stage comprising a shallow linear autoencoder.

### Feature Extraction

Features are extracted by feeding the images through a ResNet50 backbone, which was pre-trained on ImageNet. The output of an intermediate layer (layer3 by default) of the network is used to obtain a semantic feature vector with a fixed length of 65536.

### Anomaly Detection

In the anomaly classification stage, a shallow linear autoencoder is trained on the features of the chosen layer. A feature-reconstruction scores (norm of the error between the reconstructed output of the autoencoder and the original high-dimensional feature) is calculated as the anomaly score. Anomaly map is generated by reshaping and resizing the error tensor to match the input image dimension.

## Usage

`anomalib train --model Fre --data anomalib.data.MVTec`

## Benchmark

All results gathered with seed `42`.

## [MVTec AD Dataset](https://www.mvtec.com/company/research/datasets/mvtec-ad)

> Note: Metrics for ResNet 50 were calculated with pooling kernel size of 2 while for Wide ResNet 50, kernel size of 4 was used.

### Image-Level AUC

|                |  Avg  | Carpet | Grid  | Leather | Tile  | Wood  | Bottle | Cable | Capsule | Hazelnut | Metal Nut | Pill  | Screw | Toothbrush | Transistor | Zipper |
| -------------- | :---: | :----: | :---: | :-----: | :---: | :---: | :----: | :---: | :-----: | :------: | :-------: | :---: | :---: | :--------: | :--------: | :----: |
| ResNet-50      | 0.933 | 0.951  | 0.817 |    1    | 0.991 | 0.988 | 0.996  | 0.931 |  0.887  |  0.974   |   0.902   | 0.951 | 0.798 |   0.908    |   0.943    | 0.957  |
| Wide ResNet-50 | 0.947 | 0.928  | 0.909 |    1    | 0.991 | 0.950 | 0.996  | 0.944 |  0.908  |  0.973   |   0.933   | 0.971 | 0.827 |   0.950    |   0.963    | 0.968  |

### Image F1 Score

|                |  Avg  | Carpet | Grid  | Leather | Tile  | Wood  | Bottle | Cable | Capsule | Hazelnut | Metal Nut | Pill  | Screw | Toothbrush | Transistor | Zipper |
| -------------- | :---: | :----: | :---: | :-----: | :---: | :---: | :----: | :---: | :-----: | :------: | :-------: | :---: | :---: | :--------: | :--------: | :----: |
| ResNet-50      | 0.935 | 0.928  | 0.887 |  0.995  | 0.982 | 0.975 | 0.984  | 0.906 |  0.943  |  0.943   |   0.914   | 0.943 | 0.872 |   0.912    |   0.880    | 0.958  |
| Wide ResNet-50 | 0.941 | 0.919  | 0.906 |  0.989  | 0.982 | 0.948 | 0.984  | 0.911 |  0.951  |  0.950   |   0.934   | 0.960 | 0.885 |   0.931    |   0.895    | 0.967  |
