// function createAudioHTML(path, flat) {
//   if (flat) {
//     return '<audio controls controlslist="nodownload" class="px-1" style="width: 36vw;"> <source src=' +
//         path +
//         ' type="audio/wav">Your browser does not support the audio element.</audio>';
//   }
//   return '<audio controls controlslist="nodownload" class="px-1"> <source src=' +
//       path +
//       ' type="audio/wav">Your browser does not support the audio element.</audio>';
// }


function createAudioHTML(path, flat) {
  if (flat) {
    // Used in wide context, e.g., full-width comparison panel
    return (
      '<audio controls controlslist="nodownload" class="px-1" style="width: 36vw;">' +
      '<source src="' + path + '" type="audio/wav">' +
      'Your browser does not support the audio element.</audio>'
    );
  }

  // Compact player for table cells
  return (
    '<audio controls controlslist="nodownload" class="px-1" style="width: 100%; max-width: 180px;">' +
    '<source src="' + path + '" type="audio/wav">' +
    'Your browser does not support the audio element.</audio>'
  );
}



function createFigureHTML(path, flat) {
  if (flat) {
    return '<img src=' + path + ' style="width: 9vw;">';
  }
  return '<img src=' + path + '>';
}

function createTextHTML(textContent, flat) {
  if (flat) {
    return '<div style="white-space: pre-wrap; font-size: 0.9rem; width: 36vw;">' + textContent + '</div>';
  }
  return '<div style="white-space: pre-wrap;">' + textContent + '</div>';
}



function generate_normal_sample(tableId, directory, audioList, transcriptionList) {
  let table = document.getElementById(tableId);

  // Clear all rows except header
  let nrRows = table.rows.length;
  for (let i = 1; i < nrRows; i++) {
    table.deleteRow(1);
  }

  // Insert rows (up to length of audioList or 4)
  const maxRows = audioList.length;
  for (let i = 0; i < maxRows; i++) {
    let row = table.insertRow(i + 1);
    row.style.height = '80px';

    if (i < audioList.length) {
      const audioId = audioList[i];
      const transcription = transcriptionList[i] || "";

      // 1. Transcription
      let cell = row.insertCell(0);
      cell.innerHTML = transcription;
      cell.style.textAlign = "center";

      // 2. Prompt1
      cell = row.insertCell(1);
      cell.innerHTML = createAudioHTML(`${directory}/prompt/${audioId}/prompt1.wav`, false);
      cell.style.textAlign = "center";

      // 3. Prompt2
      cell = row.insertCell(2);
      cell.innerHTML = createAudioHTML(`${directory}/prompt/${audioId}/prompt2.wav`, false);
      cell.style.textAlign = "center";

      // 4. Ours
      cell = row.insertCell(3);
      cell.innerHTML = createAudioHTML(`${directory}/ours/${audioId}.wav`, false);
      cell.style.textAlign = "center";

      // 5. MoonCast
      cell = row.insertCell(4);
      cell.innerHTML = createAudioHTML(`${directory}/mooncast/${audioId}.wav`, false);
      cell.style.textAlign = "center";

      // 6. Sesame
      cell = row.insertCell(5);
      cell.innerHTML = createAudioHTML(`${directory}/sesame/${audioId}.wav`, false);
      cell.style.textAlign = "center";
    } else {
      // Fill with empty cells
      for (let j = 0; j < 6; j++) {
        let cell = row.insertCell(j);
        cell.innerHTML = '<br>';
        cell.style.textAlign = "center";
      }
    }
  }
}



function generate_normal_sample_prompt_merge(tableId, directory, audioList, transcriptionList) {
  let table = document.getElementById(tableId);

  // Clear all rows except header
  let nrRows = table.rows.length;
  for (let i = 1; i < nrRows; i++) {
    table.deleteRow(1);
  }

  // Insert rows (up to length of audioList or 4)
  const maxRows = audioList.length;
  for (let i = 0; i < maxRows; i++) {
    let row = table.insertRow(i + 1);
    row.style.height = '80px';

    if (i < audioList.length) {
      const audioId = audioList[i];
      const transcription = transcriptionList[i] || "";

      // 1. Transcription
      let cell = row.insertCell(0);
      cell.innerHTML = transcription;
      cell.style.textAlign = "center";

      // 2. Prompt1
      cell = row.insertCell(1);
      cell.innerHTML ='<div style="display: flex; flex-direction: column; align-items: center;">' +
    createAudioHTML(`${directory}/prompt/${audioId}/prompt1.wav`, false) +
    createAudioHTML(`${directory}/prompt/${audioId}/prompt2.wav`, false) +  '</div>';
      cell.style.textAlign = "center";

      // 4. Ours
      cell = row.insertCell(2);
      cell.innerHTML = createAudioHTML(`${directory}/ours/${audioId}.wav`, false);
      cell.style.textAlign = "center";

      // 5. MoonCast
      cell = row.insertCell(3);
      cell.innerHTML = createAudioHTML(`${directory}/mooncast/${audioId}.wav`, false);
      cell.style.textAlign = "center";

      // 6. Sesame
      cell = row.insertCell(4);
      cell.innerHTML = createAudioHTML(`${directory}/sesame/${audioId}.wav`, false);
      cell.style.textAlign = "center";
    } else {
      // Fill with empty cells
      for (let j = 0; j < 6; j++) {
        let cell = row.insertCell(j);
        cell.innerHTML = '<br>';
        cell.style.textAlign = "center";
      }
    }
  }
}



function generate_only_ours_sample(tableId, directory, audioList, transcriptionList) {
  let table = document.getElementById(tableId);

  // Clear all rows except header
  let nrRows = table.rows.length;
  for (let i = 1; i < nrRows; i++) {
    table.deleteRow(1);
  }

  // Insert rows (up to length of audioList or 4)
  const maxRows = audioList.length;
  for (let i = 0; i < maxRows; i++) {
    let row = table.insertRow(i + 1);
    row.style.height = '80px';

    if (i < audioList.length) {
      const audioId = audioList[i];
      const transcription = transcriptionList[i] || "";

      // 1. Transcription
      let cell = row.insertCell(0);
      cell.innerHTML = transcription;
      cell.style.textAlign = "center";

      // 2. Prompt1
      cell = row.insertCell(1);
      cell.innerHTML ='<div style="display: flex; flex-direction: column; align-items: center;">' +
    createAudioHTML(`${directory}/prompt/${audioId}/prompt1.wav`, false) +
    createAudioHTML(`${directory}/prompt/${audioId}/prompt2.wav`, false) +  '</div>';
      cell.style.textAlign = "center";


      // 4. Ours
      cell = row.insertCell(2);
      cell.innerHTML = createAudioHTML(`${directory}/ours/${audioId}.wav`, false);
      cell.style.textAlign = "center";

    } else {
      // Fill with empty cells
      for (let j = 0; j < 4; j++) {
        let cell = row.insertCell(j);
        cell.innerHTML = '<br>';
        cell.style.textAlign = "center";
      }
    }
  }
}




generate_normal_sample_prompt_merge('table-zero-shot-sample', "source/en2en-samples-normalized/", ["dailydialog-020","dailydialog-000"], [ "Why'd you pull me over? | Are you aware that you drove through a red light? | I ran a red light? | Yes, you did. | I apologize, but I didn't realize that I did. | Weren't you taught that yellow means slow down, not speed up? | I did learn that. | So, then why did you speed up? | I don't know what to tell you. | I'm going to have to write you a ticket. | I understand. | Here you go. Don't do that again.", "Hey man, you wanna buy some weed? | Some what? | Weed! You know? Pot, Ganja, Mary Jane some chronic! | Oh, umm, no thanks. | I also have blow if you prefer to do a few lines. | No, I am ok, really. | Come on man! I even got dope and acid! Try some! | Do you really have all of these drugs? Where do you get them from? | I got my connections! Just tell me what you want and I'll even give you one ounce for free. | Sounds good! Let's see, I want. | Yeah? | I want you to put your hands behind your head! You are under arrest!"]);

generate_normal_sample_prompt_merge('table-celebrity-sample', "source/en2en-samples-normalized/", ["dailydialog-530","multiturn1-000"], ["Is there anything wrong? | I'm worried about my daughter. She can't decide about college. | Don't worry. That's just a part of being a teenager. | I don't mind that. But she disagrees with me about everything. | You should encourage her to make up her mind by herself. You shouldn't affect her decision. | But I just want to give her some tips. | Oh, she can make her own decisions. | I guess you are right. | Believe me. Everything will be ok. | I hope so.", "Hey, did you see the new café on Main Street? | No, what's it called? | Brew Haven. Looks cozy. | Oh, I've heard about it! Their pastries are amazing. | Really? We should check it out. | Definitely. How about this weekend? | Saturday works. What time? | Let's go at ten. it is absolutely breakfast vibes. | Perfect. I'll meet you there. | Great! Can't wait to see you!"]);

generate_only_ours_sample('table-crosslingual-sample', "source/zh2en-samples/", ["dailydialog-101","dailydialog-102"], ["Can you tell me where the pots and pans are? | Pots and pans are right over there. | Oh, thank you. | Could I interest you in our store credit card? | No, thanks. I already have credit cards. | But our credit card saves you 10%. | That's a nice discount. | Here. Let me give you an application form. | Thank you, but I'm just browsing today. | Okay. Enjoy your browsing.", "Here is the fish counter. Look at the lobsters and crabs. Shall we have some? | I'm allergic to these things, you know. | Sorry, I forgot. I don't like seafood, neither. | Let's go over there and get some milk, a couple dozen eggs and some orange juice. | Let's get frozen juice. It is really good. We have got enough food. Let' s go over to the check-out stand. | OK. But just let me pick up a bottle of cooking wine and oil as we go by."]);

generate_only_ours_sample('table-overlap-sample', "source/overlap-samples/", ["overlap5","overlap10"], ["Seriously, Jamie? You didn’t think to tell me about this? I had to find out from someone else | Oh! come on! It’s not that big of a deal. ", "Hey, guys! I think we should focus on the marketing strategy first. If we can get the word out there, we'll have a better chance of attracting more customers. | yeah yeah I agree with you"]);


