## Project Setup

This project contains the code for the ICLR 2025 paper: *"Tackling the Abstraction and Reasoning Corpus with Vision Transformers: The Importance of 2D Representation, Positions, and Objects."*

This project depends on the re_arc directory, which is cloned from the [re-arc GitHub repository](https://github.com/michaelhodel/re-arc.git). 

To set up the project and run it correctly, follow these steps:

1. **Clone this repository:**

    ```bash
    git clone <your-project-repo-url>
    cd <your-project-directory>
    ```

2. **Set up the Python environment:**

    Ensure you are using a Python environment with the necessary dependencies. You can install them by using the `requirements.txt` file:

    ```bash
    pip install -r requirements.txt
    ```

3. **Run the setup script:**

    After navigating to the project directory, run the setup script to clone the `re-arc` repository into the `re_arc` directory and add the necessary `__init__.py` file.

    ```bash
    ./setup.sh
    ```

    This will:
    - Clone the `re-arc` repository directly into the `re_arc` directory.
    - Add an `__init__.py` file to make it a Python package.

---

Ensure that all steps are followed carefully to ensure the project is set up correctly for running the experiments.
