#!/bin/bash

# Clone the re-arc repository into re_arc directory
git clone https://github.com/michaelhodel/re-arc.git re_arc

# Check if the clone was successful
if [ -d "re_arc" ]; then
    echo "Cloned 're-arc' into 're_arc'."

    # Add an __init__.py file if it doesn't exist
    if [ ! -f "re_arc/__init__.py" ]; then
        touch re_arc/__init__.py
        echo "Created __init__.py in re_arc."
    else
        echo "__init__.py already exists in re_arc."
    fi

    echo "Setup completed successfully."
else
    echo "Failed to clone the re-arc repository. Please check the repository URL or your internet connection."
    exit 1
fi

