#!/bin/bash

# Define the arrays
datasets=("PartitionedMNIST")
models=("MLP" "CNN_MNIST")
ratios=(0.1 0.3 0.5 0.7 0.9 1.0)
alphas=(0.1 0.3 0.5 0.7 0.9 1.0)
lrs=(0.001 0.01 0.05 0.1)

# Directory to store logs
mkdir -p logs_mnist_qproxskip

# Loop through the arrays
for dataset in "${datasets[@]}"; do
  for model in "${models[@]}"; do
    for ratio in "${ratios[@]}"; do
      for alpha in "${alphas[@]}"; do
        for lr in "${lrs[@]}"; do
          # Log file path
          log_file="logs_mnist_qproxskip/${dataset}_${model}_ratio${ratio}_alpha${alpha}_lr${lr}.log"
          # Command to run
          cmd="python ProxSkip.py --dataset \"$dataset\" --k_ratio \"$ratio\" --model \"$model\" --lr \"$lr\" --alpha \"$alpha\""
          # Run the command and redirect both stdout and stderr to the log file
          $cmd > "$log_file" 2>&1
        done
      done
    done
  done
done
