# Generating experiments

This directory contains the code for generating experiments. <br>

# File naming style guide
In order to make each experiment.py file unique, the following
file naming style guide is proposed. <br>

The final paragraph describes the importance of file naming uniqueness. <br>

Each experiment (for a given permutation of parameters) will have a
corresponding bash script to run a specific python file (according to
`experiment_template.py`) which will in turn produce a unique pkl file with
the output data, where the pkl file will have the same filename as
the experiment with the difference being the file type, either `.py` or `.pkl`

Each filename should have the following components:
Note that the first two components the user will decide,
and the final two component is defined automatically based upon parameter ranges
  1. User Identifier / signature
  2. Number to enumerate each batch of jobs per user
    corresponding to these parameter experiments. Example below.
  3. Topology Idenitifier (string)
  4. Number that enumerates parameter ranges

To clarify:
  Out of the individuals who will run experiments on the super computer
we can each have a unique 2 letter string identifier, probably pertaining to
first letter of first and last name, or something similar. Each person can select one of the following signatures that uniquely describes them: `['JW','DJ','BW','JJ','IB']`, this signature will become the first two letters of all the file names generated by the user.

For example: If it's my second time running a batch on the supercomputer, corresponding to these experiments, then the prefix to the filename would be `"JW2_barab1"` for the
`"barab1"` topology, and if it
was my third batch then the filename prefix would be `"JW3_barab1"`

Then the `parameter_experiments.py` will produce enumerations for parameter ranges
for the final number of each file name.

Example of complete filenames are:
  * `"JW2_barab1_1"`
  * `"JW3_watts3_100"`
  * `"DJ5_erdos_444"`

Thus each bash script and `experiment.py` file will be uniquely names, and will
produce one unique pickle file with the same name as the `experiment.py` file.
For example `JW2_barab1_1.py`, `JW2_barab1_1.sh`, `JW2_barab1_1.pkl` will be the
three necessary files for that experiment with specific parameter ranges.

The purpose of having a unique file naming system is to systematically compile
all the resulting pkl files exactly once into one primary output file. Thus only one
file need be retained for each batch that is run per user on the supercomputer.
Ultimately, all the primary output files per batch per user can be combined into one
"ultimate" output data file for comprehensive analysis.  
