(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      3722,        104]
NotebookOptionsPosition[      3340,         90]
NotebookOutlinePosition[      3675,        105]
CellTagsIndexPosition[      3632,        102]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "\n",
 StyleBox["Plot Python Adjacency Matrices as Networks in Mathematica\n\n",
  FontSize->24,
  FontWeight->"Regular",
  FontColor->RGBColor[
   0.9740291447318227, 0.3026626993209735, 0.32771801327534905`]],
 StyleBox["Save the desired matrix to a .dat file using the following Python \
code. (Remember to convert sparse matrices to dense matrices.)\n\n",
  FontSize->14,
  FontWeight->"Regular",
  FontColor->RGBColor[0., 0., 0.]],
 StyleBox["\timport numpy as np\n\t\n\t# Make adj matrix\n\tA = \
np.random.rand(10,10)\n\tA[A > .7] = 0\n\t\n\t# Save matrix\n\t# Not sure why \
but I think I had to use float32 to get this to work\n\tA.astype(\
\[OpenCurlyQuote]float32\[CloseCurlyQuote]) \n\t\
A.tofile(\[OpenCurlyQuote]my_adj_file.dat\[CloseCurlyQuote])\n\t\n",
  FontFamily->"Bitstream Vera Sans Mono",
  FontSize->14,
  FontWeight->"Regular",
  FontColor->RGBColor[0., 0., 0.]],
 StyleBox["After the matrix is saved, move the .dat file to the same \
directory as this script and use the following function to load it into \
Mathematica.",
  FontSize->14,
  FontWeight->"Regular",
  FontColor->RGBColor[0., 0., 0.]]
}], "Text",
 CellChangeTimes->{{3.807015944599866*^9, 3.807015984928132*^9}, {
   3.807016029001356*^9, 3.807016213344713*^9}, {3.8070163515428143`*^9, 
   3.80701655392467*^9}, 3.807016616489262*^9, {3.8070168235449944`*^9, 
   3.807016836760356*^9}},ExpressionUUID->"c1d75cca-b4ee-4ef6-98a9-\
6fd3b9454d42"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadPyAdj", "[", "fname0_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"fname", " ", "=", " ", "fname0"}], ",", " ", "data", ",", " ", 
      "n", ",", " ", "adj", ",", " ", "g"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"data", "=", 
      RowBox[{"BinaryReadList", "[", 
       RowBox[{"fname", ",", "\"\<Real32\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", " ", "=", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Length", "[", "data", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"adj", " ", "=", " ", 
      RowBox[{"ArrayReshape", "[", 
       RowBox[{"data", ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AdjacencyGraph", "[", 
      RowBox[{"adj", ",", 
       RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", " ", 
  RowBox[{"LoadPyAdj", "[", "\"\<my_adj_file.dat\>\"", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8070166498976927`*^9, 3.8070168141322203`*^9}, {
  3.8070168470496273`*^9, 
  3.807016875036785*^9}},ExpressionUUID->"6a1b4d3f-76f5-4bf6-a973-\
abc47bc31082"]
},
WindowSize->{808, 675},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1450, 32, 428, "Text",ExpressionUUID->"c1d75cca-b4ee-4ef6-98a9-6fd3b9454d42"],
Cell[2011, 54, 1325, 34, 157, "Input",ExpressionUUID->"6a1b4d3f-76f5-4bf6-a973-abc47bc31082"]
}
]
*)

