#!/bin/bash -l
set -euo pipefail

python3.11 slurm.py \
 --sh-dir ./scripts/auto_generated/exhaustive_collisions \
 --py-path src/ablations/exhaustive_collisions.py \
 -i ./data/dataset_exp/gpt2/top101000-closest-12.csv \
 -o exhaustive \
 --sh-name gpt2.sh \
 -n 10 \
 --sample-idx -1 \
 --batch-size 64 \
 --model-id openai-community/gpt2 \
 --output exhaustive-gpt2 \
 --time 04:00:00 > /dev/null 2>&1 &

for i in {0..9}; do
  python3.11 slurm.py \
    --sh-dir ./scripts/auto_generated/exhaustive_collisions \
    --py-path src/ablations/exhaustive_collisions.py \
    -i ./data/dataset_exp/gemma-3-1b-pt/top101000-closest-26.csv \
    -o exhaustive \
    --sh-name gemma-3-1b-pt-"$i".sh \
    -n 10 \
    --sample-idx "$i" \
    --batch-size 64 \
    --model-id google/gemma-3-1b-pt \
    --output exhaustive-gemma-3-1b-pt-"$i" \
    --time 04:00:00 > /dev/null 2>&1 &
done