#!/bin/bash -l
set -euo pipefail

# --- repos ---
REPOS=(
  "roneneldan/TinyStories-1M"
  "roneneldan/TinyStories-8M"
  "roneneldan/TinyStories-33M"
  "openai-community/gpt2"
  "openai-community/gpt2-medium"
  "openai-community/gpt2-large"
  "google/gemma-3-1b-pt"
  "google/gemma-3-4b-pt"
  "google/gemma-3-12b-pt"
  "microsoft/Phi-4-mini-instruct"
  "mistralai/Mistral-7B-v0.1"
  "meta-llama/Llama-3.1-8B"
)

# Keep track of extra/unrecognized flags to forward verbatim
EXTRA_TOKEN_ARGS=()

usage() {
  cat <<EOF
Usage: $0 [ARGUMENTS]

Any unrecognized flags are forwarded verbatim to the token args.
EOF
  exit 0
}

# --- parse CLI, replacing defaults when specified ---
while [[ $# -gt 0 ]]; do
  case "$1" in
    -h|--help) usage ;;
    # everything else: forward verbatim to token args
    *)
      EXTRA_TOKEN_ARGS+=("$1"); shift; continue ;;
  esac
done

# --- helpers ---
name_from_repo() { echo "${1##*/}"; }

# --- main loop ---
for MODEL_ID in "${REPOS[@]}"; do
  NAME="$(name_from_repo "$MODEL_ID")"

  SH_NAME_ARG=( --sh-name "${NAME}.sh" )
  MODEL_ARGS=( --model-id "${MODEL_ID}" --output "find_close-${NAME}" )

  # Build and exec command (safe array invocation)
  CMD=( python3.11 slurm.py --sh-dir ./scripts/auto_generated/find_close )
  CMD+=( --py-path src/ablations/find_close.py -dir ./data/dataset_exp )
  CMD+=( "${SH_NAME_ARG[@]}" )
  CMD+=( "${EXTRA_TOKEN_ARGS[@]}" )
  CMD+=( "${MODEL_ARGS[@]}" )
  CMD+=( --time 06:00:00 )

  echo "+ ${CMD[*]}"
  "${CMD[@]}" > /dev/null 2>&1 &
done
