#!/bin/bash -l
set -euo pipefail

for i in {0..9}; do
  python3.11 slurm.py \
    --sh-dir ./scripts/auto_generated/pez \
    --py-path src/methods/PEZ.py \
    --sh-name gpt2-$i.sh \
    --output pez-gpt2-$i \
    --model-id openai-community/gpt2 \
    -i data/sip-it/correctness/dataset \
    -o data/pez \
    --rank $i --pct 0.1 \
    --time 20:00:00 > /dev/null 2>&1 &
done
