#!/bin/bash -l
set -euo pipefail

python3.11 slurm.py \
 --sh-dir ./scripts/auto_generated/seq_length \
 --py-path src/ablations/dataset_collisions.py \
 -o seq_length \
 --sh-name gpt2.sh \
 -n 2500 \
 --prompt-tokens 500 \
 -mcl 20 \
 -cis 20 \
 --batch-size 64 \
 --model-id openai-community/gpt2 \
 --output seq_length-gpt2 \
 --time 04:00:00 > /dev/null 2>&1 &

python3.11 slurm.py \
 --sh-dir ./scripts/auto_generated/seq_length \
 --py-path src/ablations/dataset_collisions.py \
 -o seq_length \
 --sh-name gemma-3-1b-pt.sh \
 -n 2500 \
 --prompt-tokens 500 \
 -mcl 20 \
 -cis 20 \
 --batch-size 64 \
 --model-id google/gemma-3-1b-pt \
 --output seq_length-gemma-3-1b-pt \
 --time 04:00:00 > /dev/null 2>&1 &