#!/bin/bash -l
set -euo pipefail

for i in {0..9}; do
  python3.11 slurm.py \
    --sh-dir ./scripts/auto_generated/sip-it-correctness \
    --py-path src/methods/SIP-It.py \
    --sh-name gpt2-$i.sh \
    --output sip-it-correctness-gpt2-$i \
    --model-id openai-community/gpt2 \
    -i data/sip-it/correctness/dataset \
    -o data/sip-it/correctness \
    --rank $i --pct 0.1 \
    --time 12:00:00 > /dev/null 2>&1 &
done
