#!/bin/bash -l
set -euo pipefail

for j in {1..12}; do
  python3.11 slurm.py \
    --sh-dir ./scripts/auto_generated/sip-it-layer-ablation \
    --py-path src/methods/SIP-It.py \
    --sh-name gpt2-$j.sh \
    --output sip-it-layer-ablation-gpt2-$j \
    --model-id openai-community/gpt2 \
    -i data/sip-it/correctness/dataset \
    -o data/sip-it/layer-ablation/layer$j \
    --rank 0 --pct 0.1 --layer $j \
    --time 12:00:00 > /dev/null 2>&1 &
done
