#!/bin/bash -l
set -euo pipefail

# List of dataset input files
dataset_files=(
  "./data/law_a.csv"
  "./data/law_b.yaml"
  "./data/patients_a.csv"
  "./data/patients_b.json"
  "./data/patients_c.tsv"
)

# Loop over array and launch jobs
for i in "${!dataset_files[@]}"; do
  python3.11 slurm.py \
    --sh-dir ./scripts/auto_generated/sip-it-long \
    --sh-name "data$i.sh" \
    --py-path src/methods/SIP-It-Long.py \
    --output "sip-it-long-$i" \
    --time 12:00:00 \
    -i "${dataset_files[$i]}" \
    -o sip-it-long \
    --model-id openai-community/gpt2 \
    --rank "$i" > /dev/null 2>&1 &
done
