#!/bin/bash -l
set -euo pipefail

for i in {0..9}; do
  python3.11 slurm.py \
    --sh-dir ./scripts/auto_generated/sip-it-random \
    --py-path src/methods/SIP-It-Random.py \
    --sh-name gpt2-$i.sh \
    --output sip-it-random-gpt2-$i \
    --model-id openai-community/gpt2 \
    -i data/sip-it/random/dataset \
    -o data/sip-it/random \
    --rank $i --pct 0.1\
    --time 00:30:00 --qos boost_qos_dbg > /dev/null 2>&1 &
done
