# RoGra
This is our implementation for the paper: Robust EEG classification via Graph Neural Networks submitted to ICLR.

## Installation
Please ensure to use Python 3.6. Python 3.7+ is not supported.
```
pip3 install -r requirements.txt
```

## Datasets
Please download the datasets under https://drive.google.com/file/d/1RxN2PWOkYJw-NzyM0vaxdLkina2q-_Rj/view and save them 
in the /data folder. Secondly, run
```
extract_data.py
```
in the data folder to extract the datasets. This will also compute the DTWs as a one-time preprocessing step.

## Quick Start

To train our model you can run the following command:
```
python train_RoGra.py --dataset bci --subject 1
```
To run any other dataset or subject change the corresponding arguments. The options are:
```
bci: [1,2,3,4,5,6,7,8,9]
mamem: [1,2,3,4,5,6,7,8,9,10,11]
bcicha: [2,6,7,11,12,13,14,16,17,18,20,21,22,23,24,26]
```

For additonal hyperparameters and model configurations please refer to the arguments in the train_RoGra.py file. We have
set the default values to represent the ones use for the evaluation in the paper.

All the logs will be saved in `logs/`


## Citation
This frame work is based on the following paper:
Zha, Daochen, et al. "Towards similarity-aware time-series classification." Proceedings of the 2022 SIAM International 
Conference on Data Mining (SDM). Society for Industrial and Applied Mathematics, 2022.



