import os
import numpy as np
from src.utils import read_dataset, read_eeg_dataset

def create_dataset(args, eeg_datasets):

    eeg_dir = 'datasets/eeg'
    tsc_dir = './datasets/tsc'
    output_dir = './tmp'

    # Seeding
    np.random.seed(args.seed)

    # Create dirs
    if args.dataset in eeg_datasets:
        output_dir = os.path.join(output_dir, 'eeg_datasets_'+str(args.shot)+'_shot')
    else:
        output_dir = os.path.join(output_dir, 'tsc_datasets_'+str(args.shot)+'_shot')
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)

    # Read data
    if args.dataset in eeg_datasets:
        X, y, train_idx, test_idx = read_eeg_dataset(eeg_dir, args.dataset, args.subject, args.shot)
    else:
        X, y, train_idx, test_idx = read_dataset(tsc_dir, args.dataset, args.shot)
    data = {
                'X': X,
                'y': y,
                'train_idx': train_idx,
                'test_idx': test_idx
            }
    np.save(os.path.join(output_dir, args.dataset), data)
