#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Dec 21 11:05:23 2020

@author: pooya
"""

################## import files
import scipy.io as sio
from scipy.io import savemat
from sklearn.ensemble import RandomForestRegressor
from sklearn.tree import DecisionTreeRegressor
from sklearn.cluster import KMeans
import numpy as np
################## set parameters

dataset_name = 'slice_localization_data'

T_depth = [5,6,7,8]
K=500
#################
mat_contents = sio.loadmat(dataset_name+'_mat.mat')
Xtr = mat_contents['Xtr']
Ytr = mat_contents['Ytr']
#Ytr = Ytr.reshape((Ytr.shape[0]))
#Ytr = Ytr.reshape(Ytr.shape[0])

Xv = mat_contents['Xv']
Yv = mat_contents['Yv']
#Yv = Yv.reshape((Yv.shape[0]))
#Yv = Yv.reshape(Yv.shape[0])

X_test = mat_contents['X_test']
Y_test = mat_contents['Y_test']
#Y_test = Y_test.reshape((Y_test.shape[0]))
#Y_test = Y_test.reshape(Y_test.shape[0])

##N=np.shape(Xtr)
##select = np.random.permutation(N[0])
##Ytr = Ytr-1
##N01=int(np.ceil(N[0]/100))

##Xv = Xtr[select[Data_set_portion*N01+1:(Data_set_portion*N01+1)+CV_portion*N01],:]
##Yv = Ytr[select[Data_set_portion*N01+1:(Data_set_portion*N01+1)+CV_portion*N01]]
##Xtr = Xtr[select[0:Data_set_portion*N01],:]
##Ytr = Ytr[select[0:Data_set_portion*N01]]


######################## run init

print('training tree')
DTC = DecisionTreeRegressor(max_depth=12)
RF = DTC.fit(Xtr,Ytr.ravel())
Y_pred = RF.predict(X_test)
Y_pred = Y_pred.reshape(Y_pred.shape[0],1)
Err_bag_test_no = np.sum(np.sum(np.power((Y_test-Y_pred),2),axis=1)**1)/X_test.shape[0]

print('tree test', Err_bag_test_no)

print('training')
DTC = RandomForestRegressor(max_depth=10, n_estimators=K, max_features=None)
RF = DTC.fit(Xtr,Ytr.ravel())
Y_pred = RF.predict(X_test)
Y_pred = Y_pred.reshape(Y_pred.shape[0],1)
Err_bag_test_no = np.sum(np.sum(np.power((Y_test-Y_pred),2),axis=1)**1)/X_test.shape[0]

print('RF test', Err_bag_test_no)