#!/bin/bash

saved_location="runs"
truncation_thresholds=(0.4 0.5 0.6 0.7 0.8 0.9)

# Dataset configurations
declare -A datasets
datasets=(
  ["pets"]=37
  ["flowers102"]=102
  ["cub200"]=200
  ["cifar10"]=10
  ["cifar100"]=100
)

# Model names
models=("swinT")

# List of num_of_finetune values and corresponding budgets
num_of_finetune_list=(all)


declare -A budgets=(
  ["pets"]="4.316520691 13.43759918 39.96430588 113.7461777 311.1638794 869.9942627"
  ["flowers102"]="4.172336578 13.01542664 39.32069016 113.3018494 309.9431458 850.3220215"
  ["cub200"]="2.871421814 9.569282532 30.51263809 92.30654907 262.0888977 786.1287231"
  ["cifar10"]="0.87859726 2.208301544 5.726551056 16.83017349 60.43528748 267.5114136"
  ["cifar100"]="0.777446747 1.982582092 5.319423676 16.03069687 58.19285202 260.9542542"
)


# Common setup
setup="A"
perplexity_pkl="--model.perplexity_pkl perplexity/perplexity_swinT.pkl"
common_data_args="--data.train_workers 24 --data.val_workers 24"
common_model_args="--model.setup $setup --model.set_bn_eval True --model.use_sgd True --model.learning_rate 0.05 --model.momentum 0 --model.anneling_steps 50 --model.scheduler_interval epoch"
common_trainer_args="--trainer.max_epochs 50 --trainer.gradient_clip_val 2.0"
common_seed_args="--seed_everything 233"

# Loop through truncation thresholds
for var_index in "${!truncation_thresholds[@]}"; do
  truncation_threshold="${truncation_thresholds[var_index]}"
  echo "Running with truncation_threshold: ${truncation_threshold}"

  common_methods="--model.with_ASI True --model.truncation_threshold $truncation_threshold"
  common_args="$perplexity_pkl $common_data_args $common_model_args $common_trainer_args $common_seed_args $common_methods"
  # Loop through models and datasets
  for model in "${models[@]}"; do
    echo "Processing model: $model"

    model_config_args="--config configs/${model}_config.yaml"

    for dataset in "${!datasets[@]}"; do
      num_classes=${datasets[$dataset]}
      echo "  Processing dataset: $dataset with num_classes: $num_classes"
      specific_logger_args="--logger.save_dir ${saved_location}/setup$setup/$model/$dataset/ASI/var${truncation_threshold}/"
      specific_data_args="--data.setup $setup --data.name $dataset --data.data_dir data/$dataset"
      specific_model_args="--model.num_classes $num_classes"
      specific_args="$specific_logger_args $specific_data_args $specific_model_args"

      all_args="$model_config_args $common_args $specific_args"
      # echo $all_args

      # Get budgets for the current dataset
      IFS=' ' read -r -a dataset_budgets <<< "${budgets[$dataset]}"
      for i in "${!num_of_finetune_list[@]}"; do
        num_of_finetune="${num_of_finetune_list[i]}"
        budget="${dataset_budgets[var_index]}"

        echo "    Running with num_of_finetune: $num_of_finetune, budget: $budget"
        python trainer_cls_linear.py ${all_args} --logger.exp_name ASI_var_${truncation_threshold}_l${num_of_finetune} --model.num_of_finetune $num_of_finetune --model.budget $budget
      done
    done
  done
done
