import openai as oai
import os
import typing
import json
# from tqdm import tqdm


class OpenAIPrompting:
    '''
    Prompt OpenAI and get responses. Also write to .txt files (TO IMPLEMENT) and parse into workable data structures
    '''
    def __init__(self, model: str):
        self.model = model
        # self.n_responses = n_responses
        if 'lama' in model:
            self.client = oai.OpenAI(
                api_key = os.environ.get('TOGETHER_API_KEY'),
                base_url = 'https://api.together.xyz/v1'
            )
        else:
            self.client = oai.OpenAI(
                organization=os.environ.get('OPENAI_ORG_KEY'),
                project=os.environ.get('OPENAI_PROJECT_ID')
            )
        
        
    def get_completions(self, curr_chat: list[dict[str, str]], N_responses: int=20, temperature: float=1.0, json_mode: bool=False):
        '''
        ## TODO:
        ##  Implement **kwargs so that user can pass other things if they want beyond these explicit ones
        Given a prompt, get n_responses chat completions 

        Inputs:
            prompt (json):
                This is a json file with system and user messages. # TBD
            N_responses (int):
                This specifies how many completions I want for a given query
        Output:
            Chat completion given by openai api based on prompt and hyperparameters
        '''
        # gpt-4 does not accept response_format parameter
        if json_mode:
            completions = self.client.chat.completions.create(
                model = self.model,
                messages = curr_chat,
                n = N_responses,
                temperature = temperature,
                response_format = {'type': 'json_object'}
            )
            greedy_decode = self.client.chat.completions.create(
                model = self.model,
                messages = curr_chat,
                temperature = 0.0,
                response_format = {'type': 'json_object'}
            )
        elif 'gpt' in self.model:
            completions = self.client.chat.completions.create(
                model = self.model,
                messages = curr_chat,
                n = N_responses,
                temperature = temperature,
            )
            if temperature != 0:
                greedy_decode = self.client.chat.completions.create(
                    model = self.model,
                    messages = curr_chat,
                    temperature = 0.0,
                )
            else:
                greedy_decode = completions

        # uses the response generated by model using greedy decoding as example response to go into move 2
        curr_chat.append({'role': greedy_decode.choices[0].message.role, 'content': greedy_decode.choices[0].message.content})
        return completions
    
    def parse_outputs(self, completions) -> list[str]:
        '''
        Get list of strings which is just the text outputs of the chat completions given by openai api

        Inputs:
            completions:
                completions given by openai api
        
        Output:
            list[str]: list of strings where each string is one text output of openai
        '''
        # use response.choices[i].message.content
        responses = [completion_message.message.content for completion_message in completions.choices]
        # print(responses)


        return responses

    