# AAonBCI

Table of contents:

- [AAonBCI](#aaonbci)
  - [1. Installation](#1-installation)
  - [2. Training and Testing of EEGNet classification network](#2-training-and-testing-of-eegnet-classification-network)
  - [3. Running the attacks](#3-Running-the-attacks)
  - [4. Plotting](#4-plotting)
  
## 1. Installation

1. Download the dataset from [PhysioNet](https://physionet.org/content/eegmmidb/1.0.0/)

    ```bash
    $ wget -r -N -c -np https://physionet.org/files/eegmmidb/1.0.0/
    ```

2. Place it inside the project directory:  .../1-Data/1-PhysioNet/2-Data/ .
3. Create a conda environment from the aabci.yml file and install the dependencies.

    ```bash
    $ conda env create --name aabci --file=environment.yml

    ```

## 2. Training and Testing of EEGNet classification network

1. Activate the conda environment and run the physionet.py file.

    ```bash
    $ conda activate aabci
    $ (aabci) python physionet.py
    ```

2. It should create a file named 3class.npz inside the /1-Data/1-PhysioNet/2-Data/ directory.
3. When the training and testing are done, the models for each fold should be saved inside 1-Data/1-PhysioNet/1-Model/.

## 3. Running the attacks
1. Inside the prepare_attack() function, edit the dictionary run_params and the rest of the settings with the desired parameters for the run and save the file.
2. Select the desired perturbation amplitudes, PGD iterations with eps_list and iter_list respectively. 
2. Run the file AAHMI.py selecting the desired GPU core where it will run by passing an argument, e.g., to run on the core 3:

    ```bash
    $ (aabci) python AAHMI.py 3
    ```

3. Depending on the run, one or two files will be generated for each run inside the 2-Output/ directory:
    1. A file with the attack success rates: ASR_(...).npy
    2. An additional file for the Universal Adversarial Perturbation will be generated: v_(...).pt.

## 4 Plotting

1. To produce the plots use the plotting.ipynb file.

## 5 BCI-Competition IV 2a.
1. The data is publicly available to download from: http://bnci-horizon-2020.eu/database/data-sets under 1. Four class motor imagery (001-2014). 
2. Place the downloaded data under the designated directory /1-Data/2-BCI-Competition/2-Data. 
3. To train the net run
    ```bash
    $ (aabci) python bci-competition.py
    ```