# LAC - BabyAI-Text

## Quickstart

1. **Create conda env**
```
conda create -n babyai python=3.10.8
conda activate babyai
```
2. **Install BabyAI-Text**

Following the installation steps (2-4) in https://github.com/flowersteam/Grounding_LLMs_with_online_RL.

3. **Install other packages required**

```
pip install -r requirements.txt
```

## Reproduce

### Fine-tuning critic

An example fine-tuning Codellama7b is provided in `jobs/train_critic.sh`. You can also change the --model_name_or_path and --base_model_name to other models.

Run:
```
sh jobs/train_critic.sh 0
```
to fine-tune the model. The number in the command line specifies the GPU id you want to use.

### Evaluation on test environment

Our method and some other ablation studies for each component are written in `{LAC,LAC-wovaluecritic,LAC-valuecriticonly,LAC-wolangcritic}.py`. Examples to run those python files are provided in `jobs/{LAC,LAC-wovaluecritic,LAC-valuecriticonly,LAC-wolangcritic}.sh`. Change the --model_name_or_path and --peft_model_path in the script to evaluate other models. --peft_model_path should be specified as the path to the corresponding fine-tuned model.

You can also change --task_type to evaluate on other types of tasks.

Run:
```
sh jobs/LAC.sh 0
```
The number in the command line specifies the GPU id you want to use.
