# MERCI: Histogram-Guided Source-Free Domain Adaptive Regression

This repository implements **MERCI**, a histogram-guided framework for Source-Free Domain Adaptive Regression (SFDAR).
It supports classification-based regression uncertainty modeling, pseudo-label refinement, and robust adaptation across multiple benchmarks.

---

## ⚙️ Environment Setup

If using **conda** to manage dependencies:

```bash
conda create -n merci python=3.10
conda activate merci
pip install -r requirements.txt
```

---
## 📊 Supported Datasets and Data Preperation

- **UTKFace** (Age prediction)
  - Download from [here](https://susanqq.github.io/UTKFace/).
  - Save ```UTKface.zip``` into ```DATASOURCE/UTKface```, unzip it and the resulting ```part*.tar.gz```.
- **Biwi-Kinect** (Head pose estimation)
  - Download from [here](https://www.kaggle.com/datasets/kmader/biwi-kinect-head-pose-database).
  - Save the downloaded data into ```DATASOURCE/biwi_kinect```.
- **Digits (SVHN ↔ MNIST)** (Digits classification to regression benchmarks)
  - **SVHN**: download ```train_32x32.mat``` and ```test_32x32.mat``` from [here](http://ufldl.stanford.edu/housenumbers/), into ```DATASOURCE/digits```.
  - **MNIST**: download from [here](https://www.kaggle.com/datasets/hojjatk/mnist-dataset), into ```DATASOURCE/digits/MNIST/raw```.
- **California Houseing** (House price prediction)
  - Download ```housing.csv``` from [here](https://www.kaggle.com/datasets/camnugent/california-housing-prices), into ```DATASOURCE/california```.
  
> While training source model or execute adaptation,  pass ```DATASOURCE``` as ```--data_dir``` argument.
---

## 🚀 Getting Started

### Run a source model training experiment:
```bash
python run_train_source.py --config configs/train_source/UTKface_src_train.yaml
```

### Run our MERCI framework:
```bash
python run_adaptation_merci.py --config configs/merci/UTKface_merci.yaml
```

All logs and outputs will be saved under `output/`.

The complete version of the code, including the full implementation of MERCI and all baselines, will be released upon paper acceptance.

---

## 🔧 Configuration

All experiments are controlled by YAML files under `configs/`.

Command-line inputs have higher priority and will overwrite the values set in the YAML file if conflicts occur.

---

## 🔆 Acknowledgement

Parts of this implementation are based on the [SSA](https://github.com/kzkadc/regression-tta) repository. We thank the authors for making their code publicly available.