
SRC_MODEL_NAME ={
    'biwi_kinect':{
        'female': 'source_model_7400.pt',
        'male': 'source_model_12300.pt',
    },
    'UTKface': {
        'original': 'source_model_30200.pt',
        'female': 'source_model_16200.pt',
        'male': 'source_model_17700.pt',
        'white': 'source_model_14400.pt', 
        'black': 'source_model_6500.pt', 
        'asian': 'source_model_5100.pt', 
        'indian': 'source_model_5700.pt', 
    },
    'digits': {
        'mnist': 'source_model_93800.pt',
        'svhn': 'source_model_114500.pt'
    },
    'california':{
        'near_bay': "source_model_3600.pt",
        'far_bay': "source_model_28400.pt"
    }
}


def get_src_model_dir(config):
    dset = config['dset']
    model_dir = config['model_dir']
    source = config['source']
    seed = config['seed']
    src_model_subname = SRC_MODEL_NAME[dset].get(source, '')
    config['src_model_name'] = src_model_subname
    if dset == "biwi_kinect":
        src_subdir = config['task_info'] + "_" + source
    else:
        src_subdir = source

    src_model_dir = f"{model_dir}/{dset}/{src_subdir}/{str(seed)}"
    src_model_name = f"{src_model_dir}/{src_model_subname}"
    return src_model_dir, src_model_name


def get_output_dir(config, with_csv_info=False):
    # dataset/s2t_task_info/method/seed/exp_name
    dset = config['dset']

    run_type = config['run_type']
    seed = config['seed']
    source = config['source']
    target = config.get('target', None)
    main_dir = config['main_dir']
    exp_name = config['exp_name']

    task_info = config.get("task_info", None)
    src_sub = source[:2].upper() if len(source) >= 2 else source.upper()

    s2t_subname = ''
    method = config.get('method', "unknown")
    if run_type == "adaptation":
        method = config['method']
        tar_sub = target[:2].upper() if len(target) >= 2 else target.upper()
        s2t_subname = f"{src_sub}2{tar_sub}" if task_info is None else f"{src_sub}2{tar_sub}_{task_info}"
        output_dir = f"{main_dir}/{dset}/{s2t_subname}/{method}/{str(seed)}/{exp_name}"
    elif run_type == "src_train":
        subname = f"{source}_{task_info}_src_train" if dset == 'biwi_kinect' else f"{source}"
        output_dir = f"{main_dir}/{dset}/{subname}/{str(seed)}/{exp_name}"

    return output_dir
