import time
import logging



txt_logger = logging.getLogger("sfda_reg")

def TxtLogger(filename, verbosity="info", logname="sfda_reg"):
    level_dict = {
        "debug": logging.DEBUG,
        "info": logging.INFO,
        "warning": logging.WARNING,
        "error": logging.ERROR,
    }
    formatter = logging.Formatter(
        fmt="[%(asctime)s][%(filename)s][l:%(lineno)d] %(message)s",
        datefmt="%m-%d %H:%M:%S",
    )
    logger = logging.getLogger(logname)
    logger.setLevel(level_dict[verbosity])
    fh = logging.FileHandler(filename, "w")
    fh.setFormatter(formatter)
    logger.addHandler(fh)
    sh = logging.StreamHandler()
    sh.setFormatter(formatter)
    logger.addHandler(sh)

    return logger, fh, sh


def set_logger(log_name_prefix):
    now = int(round(time.time() * 1000))
    log_file = f"{log_name_prefix}_{str(time.strftime('%Y_%m_%d_%H_%M_%S', time.localtime(now / 1000)))}.log"
    return log_file
