# 🧠 t-Product Geometry-Inspired BTR Clustering on PIE Face Dataset

This project implements a **Bidirectional Tensor Representation (BTR)** model grounded in **t-product geometry** for unsupervised clustering of aligned face images from the **PIE_face_10** dataset. 

The core idea is to treat image tensors as elements of a **non-flat tensor manifold** induced by dual t-modules along rows and columns. By enforcing low-rankness simultaneously in both directions under a spectral transform (e.g., FFT), the BTR model captures the **intrinsic geometric structure** of high-dimensional visual data. This dual-mode coupling introduces curvature into the tensor space and enhances clustering affinity through a geometry-aware representation.


## 📁 Directory Structure

```
.
├── RunClustering4PIE.m         # Main script to run BTR clustering on PIE dataset
├── PIE_face_10.mat             # Tensor-formatted face dataset (22×22×680)
└── libs4clustering/            # Supporting functions for BTR model and clustering
```

## 🚀 How to Run

Open MATLAB and execute:
```matlab
run('RunClustering4PIE.m')
```

The script will:
- Load the tensor-structured PIE face data
- Perform bidirectional low-rank modeling in the transform domain
- Construct similarity matrices and apply spectral clustering (Ncut)
- Report clustering metrics: ACC, NMI, PUR

## ⚙️ Method Summary

- **Model**: Bidirectional Tensor Representation (BTR)
- **Theory**: Based on t-product geometry, capturing both horizontal and vertical patterns
- **Transform**: Uses FFT for fast spectral regularization
- **Clustering**: Performed via normalized cuts on learned affinity matrices

## 📊 Dataset

- `PIE_face_10.mat` contains 680 aligned grayscale face images (22×22), tensorized into shape (22×680×22).

## 🙏 Acknowledgements

We gratefully acknowledge the availability of public codebases from the following works, which informed and supported parts of our implementation:

- Wu, T. (2024). *Robust Data Clustering with Outliers via Transformed Tensor Low-Rank Representation*. In AISTATS, pp. 1756–1764.
- Zhou, P., Lu, C., Feng, J., Lin, Z., & Yan, S. (2019). Tensor low-rank representation for data recovery and clustering. IEEE TPAMI, 43(5), 1718-1732.
- Lu, C. (2021). *Transforms Based Tensor Robust PCA: Corrupted Low-Rank Tensors Recovery via Convex Optimization*. In ICCV, pp. 1145–1152.

We thank the authors for their open-source contributions.


