# 📦 BTR-DCT: Poisson Tensor Completion via Bidirectional Tensor Representation (DCT)

This repository implements **BTR-DCT**, a geometry-inspired tensor recovery model for photon-limited data. The method draws from the theory of **t-product geometry**, enforcing low-rank regularity along both spatial modes via the Discrete Cosine Transform (DCT).

## 📁 Project Structure

```
.
├── libs/                                     # Utility functions (unfolding, transforms, etc.)
├── f_poisson_tc_BiTNN_dct_ADMM.m             # Main ADMM solver for the BTR-DCT model
├── Indian_pines_corrected_145x145x200.mat    # Hyperspectral tensor data (H×W×B)
├── RunPoissonTC.m          # Main experimental script
```

## 🚀 Usage

To reproduce the main experiment:

1. Launch MATLAB and navigate to this folder.
2. Run the main script:
   ```matlab
   run('RunPoissonTC.m')
   ```

During execution:
- PSNR, relative error, and convergence metrics are printed per iteration.
- Final reconstruction result is stored in:  
  `memoBiTNNdct.T_hat`

## 📐 Method Summary

- **BTR-DCT** stands for *Bidirectional Tensor Representation using DCT*.
- Imposes low-rank constraints simultaneously on:
  - Mode-1 (row) unfolding
  - Mode-2 (column) unfolding
- Operates in the **DCT spectral domain** for improved structure modeling.
- Inspired by **t-product geometry**:
  - Tensors are modeled as elements of structured *t-modules*.
  - The coupling of row and column modules introduces geometric *non-flatness*, which enriches modeling power.
- Especially suited for **Poisson noise settings** and **non-uniform sampling patterns**.

## 🧪 Dataset

- The hyperspectral dataset `Indian_pines_corrected_145x145x200.mat` is used.
- Only the first 30 spectral bands are used by default for efficiency.

## 🔍 Notes

- This implementation does not require any proprietary toolbox.
- Tested in MATLAB R2021b and newer.

## 🙏 Acknowledgements

We gratefully acknowledge the availability of public codebases from the following works, which informed and supported parts of our implementation:

- Zhang, X., & Ng, M. K. (2021). Low rank tensor completion with Poisson observations. IEEE Transactions on Pattern Analysis and Machine Intelligence, 44(8), 4239-4251.
- Wang, A., Zhao, Q., Jin, Z., Li, C., & Zhou, G. (2022). Robust tensor decomposition via orientation invariant tubal nuclear norms. Science China Technological Sciences, 65(6), 1300-1317.

We thank the authors for their open-source contributions.

