function X = f_idct_tube(X)
% f_idct_tube  Apply Inverse Discrete Cosine Transform (IDCT) along the 3rd mode
%
%   This function performs an IDCT along the 3rd dimension of a 3D tensor.
%   It first unfolds the tensor along mode-3, applies IDCT to each column
%   (which corresponds to a mode-3 fiber or "tube"), and then refolds
%   the result back to the original tensor shape.
%
%   Input:
%       X - 3D tensor (e.g., height × width × frames)
%
%   Output:
%       X - Tensor after applying IDCT along the 3rd dimension (returns to time/spatial domain)

% Get original size of the tensor
sz = size(X);

% Unfold tensor along mode-3: reshape to (prod of other dims) × sz(3)
X = f_unfold_k(X, 3);

% Apply IDCT along each column (i.e., apply inverse transform to tubes)
X = idct(X);

% Refold the matrix back into a 3D tensor with the original shape
X = f_fold_k(X, sz, 3);
end
