function [PSNR, MSE] = h_Psnr(T_true, T_hat)
% h_Psnr  Compute Peak Signal-to-Noise Ratio (PSNR) and Mean Squared Error (MSE)
% 
%   Inputs:
%       T_true - Ground-truth tensor (reference)
%       T_hat  - Reconstructed or estimated tensor
%
%   Outputs:
%       PSNR   - Peak Signal-to-Noise Ratio (in decibels)
%       MSE    - Mean Squared Error between T_true and T_hat

% Convert inputs to double precision for numerical stability
T_hat = double(T_hat);
T_true = double(T_true);

% Compute pointwise squared error
dT = T_true - T_hat;
MSE = mean(dT(:).^2);  % Mean Squared Error over all elements

% Determine signal peak (assumed to be max value of ground-truth)
peak = max(T_true(:));

% Compute PSNR using standard formula
PSNR = 10 * log10(peak^2 / MSE);
end
