function memo = h_construct_memo(opts)
% h_construct_memo  Initialize a memo (log) structure for ADMM iteration tracking
%
%   Input:
%       opts - Struct containing algorithm options, including MAX_ITER_OUT
%
%   Output:
%       memo - Struct to store metrics and debug information across iterations

% Maximum number of outer iterations
max_iter = opts.MAX_ITER_OUT;

% Store the maximum iteration count and initialize iteration index
memo.max_iter = max_iter;
memo.iter = 0;

% Store original options for reference
memo.opts = opts;

% Interval for printing progress (can be customized later)
memo.printerInterval = 10;

% Preallocate memory for logging various metrics across iterations
vZero = zeros(max_iter, 1);

% Objective function values
memo.fval = vZero;

% Relative change (infinity norm) between successive iterations
memo.eps = vZero;

% Relative error to the ground truth: norm(current - true) / norm(true)
memo.err = vZero;

% Relative Squared Error (RSE): ||X - X*||_F / ||X*||_F
memo.rse = vZero;

% Squared Error (SE): ||X - X*||_F^2
memo.se = vZero;

% Peak Signal-to-Noise Ratio (PSNR)
memo.psnr = vZero;

% Structural Similarity Index Measure (SSIM)
memo.ssim = vZero;
end
