function [mean_nmi] = ncut_clustering_doubleZ(Z1,Z2,gamma, labels,t )
warning off;

K = length(unique(labels));

[n1,n2,n3]=size(Z1);
Z1=abs(Z1);
Z1=(Z1+tran(Z1))./2.0;

Z2 = abs(Z2);
Z2 = (Z2+tran(Z2))./2.0;

XX=zeros(n1,n2);

for i=1:n3
    XX=XX+0.5*gamma*(Z1(:,:,i)+Z1(:,:,i)')+0.5*(1-gamma)*(Z2(:,:,i)+Z2(:,:,i)');
end


[~,S,U] = svd(XX,'econ');
S = diag(S);
r = sum(S>1e-3*S(1));
U = U(:,1:r);S = S(1:r);
U = U*diag(sqrt(S));
U = normr(U);
L = (U*U').^t;
% spectral clustering
D = diag(1./sqrt(sum(L,2)));
L = D*L*D;

L=XX;

d=10;
results=zeros(d,3);
for p=1:d
    grps = SpectralClustering(L,K);
    [result] = ClusteringMeasure(labels,grps);
    results(p,:)=result;
end
mean_nmi=mean(results);
end

