function X = f_dct_tube(X)
% f_dct_tube  Apply Discrete Cosine Transform (DCT) along the 3rd mode (tube fibers)
%
%   This function performs a mode-3 DCT by unfolding the tensor along the 3rd mode,
%   applying DCT to each tube (i.e., each column in the unfolding), and refolding it.
%
%   Input:
%       X - Input 3D tensor (e.g., height × width × frames)
%
%   Output:
%       X - Tensor after applying DCT along the 3rd dimension (spectral domain)

% Store original size
sz = size(X);

% Unfold tensor along mode-3 into a 2D matrix of size (prod of other dims) × sz(3)
X = f_unfold_k(X, 3);

% Apply DCT along each column (tube direction)
X = dct(X);

% Refold the matrix back into the original 3D tensor shape
X = f_fold_k(X, sz, 3);
end
