function B = f_generateMaskByMode(sz, vP)
% f_generateMaskByMode  Generate structured missing mask by mode-wise dropout
%
%   Input:
%       sz  - Size of the tensor (e.g., [h, n, w])
%       vP  - Dropout ratio vector for each mode (same length as sz)
%             Each entry vP(i) in (0,1) indicates the fraction of mode-i
%             fibers (columns) to be dropped (set to zero)
%
%   Output:
%       B   - Binary mask tensor (same size as sz), with 0 = dropped, 1 = kept
%             Structured dropout is applied mode-by-mode using unfolding.

% Initialize binary mask as all-ones tensor (everything observed)
B = ones(sz);

nMode = length(sz);  % Number of tensor modes

% Loop through each mode and apply dropout
for iM = 1:nMode
    % Unfold tensor along mode-i into matrix of size (dim_i × prod(other_dims))
    B = f_unfold_k(B, iM);
    
    [~, c] = size(B);       % Get number of fibers (columns) along this mode
    sr = vP(iM);            % Dropout ratio for this mode
    ss = round(sr * c);     % Number of columns to be dropped

    % Randomly permute column indices and drop ss columns
    p = randperm(c);
    B(:, p(1:ss)) = 0;      % Set selected columns (fibers) to zero

    % Fold the matrix back to tensor shape along mode-i
    B = f_fold_k(B, sz, iM);
end
end
